string GetDescription()
{
	return "Creates a random melody line with repetitve rythm and cenetered aroun the tonic of the chord. \nLast bar gets an ending (single note)";
}

int first_pitch = 0;
int last_pitch = 0;

void SetFirstPitch(int f)
{
	first_pitch = f;
	last_pitch = f;	
}	

int GetNextPitch(int p)
{
	int cur_pitch = p;
	if (cur_pitch - 7 > last_pitch) cur_pitch -= 12;
	last_pitch = cur_pitch;
	return cur_pitch;
}

void Render(RenderPart @p)
{
	SetFirstPitch(p.GetHarmonicEventPitch(0,0));
	
	double len = RndFloat(0.5, 1.0);
	if (RndInt(0,1) == 0) len = 0.98;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (int m = 0; m < p.GetUniquePart().GetMetrum(); m++)
		{
			Time t = CreateTime(i,m);
			int vel = 127;
			if (m % 2 == 1) vel = 115;
			
			int harm = p.GetHarmonic(t);
			
			if (harm == p.GetHarmonicEvents()-1)
			{
				p.AddNote(p.GetHarmonicEventStart(p.GetHarmonicEvents()-1), p.GetHarmonicEventEnd(p.GetHarmonicEvents()-1), GetNextPitch(p.GetHarmonicEventPitch(p.GetHarmonicEvents()-1,0)) , RndInt(115,126));	
				return;
			}
			
			Time t2 = t;
			t2.m_Pos += len;
			
			p.AddNote(t, t2, GetNextPitch(p.GetHarmonicEventPitch( harm,0)) , RndInt(vel-15,vel));	
		}	
	}
}